/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;

public class PlaneSound
extends AbstractTickableSoundInstance {
    public static final Map<Integer, PlaneSound> PLAYING_FOR = Collections.synchronizedMap(new HashMap());
    private final PlaneEntity plane;
    private int fadeOut = -1;

    public PlaneSound(PlaneEntity plane) {
        super((SoundEvent)SimplePlanesSounds.PLANE_LOOP_SOUND_EVENT.get(), SoundSource.NEUTRAL);
        this.plane = plane;
        this.f_119578_ = true;
        PLAYING_FOR.put(plane.m_142049_(), this);
    }

    public static boolean isPlaying(int entityId) {
        if (!PLAYING_FOR.containsKey(entityId)) {
            return false;
        }
        PlaneSound sound = PLAYING_FOR.get(entityId);
        return sound != null && !sound.m_7801_();
    }

    public static void tryToPlay(PlaneEntity planeEntity) {
        if (!PlaneSound.isPlaying(planeEntity.m_142049_())) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PlaneSound(planeEntity));
        }
    }

    public float m_7783_() {
        return (float)Mth.m_14008_((double)((double)0.9f + this.plane.m_20184_().m_82553_() / 3.0), (double)0.9f, (double)1.3f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7788_() {
        this.f_119575_ = this.plane.m_20185_();
        this.f_119576_ = this.plane.m_20186_();
        this.f_119577_ = this.plane.m_20189_();
        if (this.fadeOut < 0 && (!this.plane.isPowered() || this.plane.getParked())) {
            this.fadeOut = 0;
            Map<Integer, PlaneSound> map = PLAYING_FOR;
            synchronized (map) {
                PLAYING_FOR.remove(this.plane.m_142049_());
            }
        } else if (this.fadeOut >= 10) {
            this.m_119609_();
        } else if (this.fadeOut >= 0) {
            this.f_119573_ = 1.0f - (float)this.fadeOut / 10.0f;
            ++this.fadeOut;
        }
    }
}

